/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.provider.pi;

import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.common.util.ByteUtilities;
import com.ibm.hsc.common.util.CmdExtendedError;
import com.ibm.hsc.common.util.CmdExtendedErrorList;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.PIParseResponse;
import com.ibm.hsc.fsp.FSPCmdMgr;
import com.ibm.hsc.fsp.FspSvrAsyncSubscription;
import com.ibm.hsc.fsp.cmdhelpers.FspCmdHelper;
import com.ibm.hsc.fsp.cmdhelpers.FspCodAsyncEventData;
import com.ibm.hsc.fsp.cmdhelpers.FspCodHistoryLog;
import com.ibm.hsc.fsp.cmdhelpers.FspCodInfo;
import com.ibm.hsc.fsp.cmdhelpers.FspCodMemoryInfo;
import com.ibm.hsc.fsp.cmdhelpers.FspCodOrderInfo;
import com.ibm.hsc.fsp.cmdhelpers.FspCodProcessorInfo;
import com.ibm.hsc.fsp.cmdhelpers.FspMeteredCodProcessorInfo;
import com.ibm.hsc.fsp.cmdhelpers.FspOnoffCodBillingInfo;
import com.ibm.hsc.fsp.cmdhelpers.FspOnoffCodMemoryInfo;
import com.ibm.hsc.fsp.cmdhelpers.FspOnoffCodProcessorInfo;
import com.ibm.hsc.fsp.cmdhelpers.FspSharedProcPoolUtilization;
import com.ibm.hsc.fsp.cmdhelpers.FspTrialCodMemoryInfo;
import com.ibm.hsc.fsp.cmdhelpers.FspTrialCodProcessorInfo;
import com.ibm.hsc.fsp.lockmgr.FspLockHelper;
import com.ibm.hsc.lock.Lock;
import com.ibm.hsc.objmgr.cec.OmCecLongRunningTask;
import com.ibm.hsc.objmgr.cec.OmCecMgr;
import com.ibm.hsc.rep.RException;
import com.ibm.hsc.rep.RObject;
import com.ibm.hsc.rep.RObjectId;
import com.ibm.hsc.rep.v50.R50ComputerSystem;
import java.io.FileInputStream;
import java.lang.reflect.Array;
import java.util.BitSet;
import java.util.Properties;
import java.util.Vector;
import org.snia.wbem.cim.CIMDataType;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;
import org.snia.wbemcfg.GlobalConfig;

public class PICodMethProcessor
implements OmCecLongRunningTask {
    private static final String METH_GET_COD_PROCESSOR_INFO = "GetCodProcessorInfo";
    private static final String METH_GET_ONOFF_COD_PROCESSOR_INFO = "GetOnoffCodProcessorInfo";
    private static final String METH_GET_METERED_COD_PROCESSOR_INFO = "GetMeteredCodProcessorInfo";
    private static final String METH_GET_TRIAL_COD_PROCESSOR_INFO = "GetTrialCodProcessorInfo";
    private static final String METH_GET_COD_MEMORY_INFO = "GetCodMemoryInfo";
    private static final String METH_GET_ONOFF_COD_MEMORY_INFO = "GetOnoffCodMemoryInfo";
    private static final String METH_GET_TRIAL_COD_MEMORY_INFO = "GetTrialCodMemoryInfo";
    private static final String METH_MANAGE_ONOFF_PROCESSORS = "ManageOnoffProcessors";
    private static final String METH_MANAGE_METERED_PROCESSORS = "ManageMeteredProcessors";
    private static final String METH_MANAGE_ONOFF_MEMORY = "ManageOnoffMemory";
    private static final String METH_DISABLE_TRIAL_RESOURCES = "DisableTrialResources";
    private static final String METH_GET_ACTIVATION_INCREMENTS = "GetActivationIncrements";
    private static final String METH_GET_ONOFF_COD_PROC_BILLING_INFO = "GetOnoffCodProcBillingInfo";
    private static final String METH_GET_ONOFF_COD_MEM_BILLING_INFO = "GetOnoffCodMemBillingInfo";
    private static final String METH_GET_COD_ORDER_INFO = "GetCodOrderInfo";
    private static final String METH_SET_COD_CTA_VALUE = "SetCodCtaValue";
    private static final String METH_SET_COD_RECOVERY_COMPLETE = "SetCodRecoveryComplete";
    private static final String METH_SET_COD_KEY = "SetCodKey";
    private static final String METH_GET_COD_HISTORY_LOG = "GetCodHistoryLog";
    private static final String METH_GET_SHARED_PROCESSOR_POOL_UTILIZATION = "GetSharedProcessorPoolUtilization";
    private static final boolean CALL_BY_VALUE = GlobalConfig.callMethodsWithValues;
    private static final String TRACE_MASK = "apcshscT";
    private static final int PHYP_BUSY = 1;
    private static final int COD_HDW_ERR = 2;
    private static final int UNRETURNED_ONOFF_RESOURCES = 3;
    private static final String COD_GENERAL_ERROR_ID = "The CoD operation failed.";
    private static final String PHYP_BUSY_ID = "PHYP is currently processing a key.";
    private static final String COD_HDW_ERR_ID = "Cod Hardware Error.";
    private static final String UNRETURNED_ONOFF_RESOURCES_ID = "Unreturned On/Off resources currently in use.";
    private static final String PERM_PROC_ACTIVATION_ID = "0500";
    private static final String PERM_MEM_ACTIVATION_ID = "0501";
    private static final String ONOFF_PROC_ENABLEMENT_ID = "0502";
    private static final String ONOFF_MEM_ENABLEMENT_ID = "0503";
    private static final String ONOFF_CAPACITY_TERMINATION_ID = "0504";
    private static final String METERED_PROC_ENABLEMENT_ID = "0505";
    private static final String TRIAL_PROC_ACTIVATION_ID = "0506";
    private static final String TRIAL_MEM_ACTIVATION_ID = "0507";
    private static final int DEFAULT_TIMEOUT_MSEC = 300000;
    private static final String TIMEOUT_PROPS_FILE = "/opt/hsc/data/hmc.properties";
    private static final String TIMEOUT_KEY = "CodKeyAsyncTimeoutInSec";
    private static final int CONF_NEEDED = 1;
    private static final int NO_CONF_NEEDED = 0;
    private static final long[] CodExtendedErrCodes = new long[]{0x20000010L, 0x20000011L, 0x40001001L, 1073750019L, 0x40002004L, 1073750021L, 1073750022L, 1073750023L, 1073750024L, 1073750025L, 1073750026L, 1073750027L, 1073750028L, 1073750029L, 1073750035L, 1073750036L, 1073750037L, 1073750040L, 1073754113L, 1073754114L, 0x40003003L, 0x40003004L, 1073754117L, 0x40004001L, 0x40004002L};
    private static final String[] setKeyErrCodeToPermProcMsgId = new String[]{null, null, "9015", "9025", "9016", "9016", "9017", "9018", "9016", null, "901A", "9044", "901C", "901E", "9019", null, "9016", "9048", null, "020D", null, null, null, "9003", "1552"};
    private static final String[] setKeyErrCodeToPermMemMsgId = new String[]{null, null, "9015", "9025", "9016", "9016", "9017", "9018", "9016", null, "901B", null, "901D", "901F", "9019", null, "9016", "9049", null, "020D", null, null, null, "9003", "1552"};
    private static final String[] setKeyErrCodeToOnoffProcMsgId = new String[]{null, null, "9015", "9025", "9016", "9016", "9017", "9018", "9016", null, "9024", "9046", null, null, "9019", null, "9016", "9048", null, "020D", null, null, null, "9003", "1552"};
    private static final String[] setKeyErrCodeToOnoffMemMsgId = new String[]{null, null, "9015", "9025", "9016", "9016", "9017", "9018", "9016", null, "9024", null, null, null, "9019", null, "9016", "9049", null, "020D", null, null, null, "9003", "1552"};
    private static final String[] setKeyErrCodeToTrialProcMsgId = new String[]{null, null, "9015", "9025", "9016", "9016", "9017", "9018", "9016", null, "9022", "9045", "9020", null, "9019", null, "9016", "9048", null, "020D", null, null, null, "9003", "1552"};
    private static final String[] setKeyErrCodeToTrialMemMsgId = new String[]{null, null, "9015", "9025", "9016", "9016", "9017", "9018", "9016", null, "9023", null, "9021", null, "9019", null, "9016", "9049", null, "020D", null, null, null, "9003", "1552"};
    private static final String[] setKeyErrCodeToMeteredProcMsgId = new String[]{null, null, "9015", "9025", "9016", "9016", "9017", "9018", "9016", null, "9047", null, null, null, "9019", null, "9016", "9048", null, "020D", null, null, null, "9003", "1552"};
    private OmCecMgr m_cecMgr;
    private RObject m_cecInst;
    private RObjectId m_cecObjId;
    private String m_cecName;
    private BitSet m_codCapsBitSet = null;
    private BitSet m_runtimeCapsBitSet = null;
    private int m_onoffCodProcState = 255;
    private int m_onoffCodMemState = 255;
    private int m_trialCodProcState = 255;
    private int m_trialCodMemState = 255;
    private int m_meteredCodProcState = 255;
    private UnsignedInt16 m_onoffCodProcIncrement;
    private UnsignedInt16 m_onoffCodMemIncrement;
    private UnsignedInt16 m_meteredCodProcIncrement;

    public PICodMethProcessor(OmCecMgr omCecMgr) {
        this.m_cecMgr = omCecMgr;
    }

    public CIMValue doCodAction(String string, Vector vector, Vector vector2) throws PIHscServerException, CIMException {
        int n;
        CIMValue cIMValue = new CIMValue((Object)new UnsignedInt8(0));
        FspCmdHelper fspCmdHelper = this.m_cecMgr.getCmdHelper();
        FSPCmdMgr fSPCmdMgr = this.m_cecMgr.getCmdMgr();
        RObject rObject = this.m_cecMgr.getObject();
        RObjectId rObjectId = this.m_cecMgr.getObjectId();
        this.m_cecInst = rObject;
        this.m_cecName = this.m_cecMgr.getCecName();
        this.m_cecObjId = rObjectId;
        boolean bl = false;
        try {
            n = ((UnsignedInt8)rObject.getProperty("State")).intValue();
            System.out.println("In PICodMethProv ... cecState = " + n);
            if (1 != n && 17 != n && 16 != n) {
                bl = true;
                throw new PIHscServerException("9010");
            }
            UnsignedInt32 unsignedInt32 = (UnsignedInt32)rObject.getProperty("RuntimeCapability");
            byte[] byArray = ByteUtilities.intToByteArray(unsignedInt32.intValue());
            this.m_runtimeCapsBitSet = ByteUtilities.byteArrayToBitSet(byArray);
            UnsignedInt32 unsignedInt322 = (UnsignedInt32)rObject.getProperty("CodCapabilities");
            byArray = ByteUtilities.intToByteArray(unsignedInt322.intValue());
            this.m_codCapsBitSet = ByteUtilities.byteArrayToBitSet(byArray);
            UnsignedInt8 unsignedInt8 = null;
            if (this.m_codCapsBitSet.get(6)) {
                this.m_onoffCodProcIncrement = (UnsignedInt16)rObject.getProperty("OnoffCodProcIncrement");
                unsignedInt8 = (UnsignedInt8)rObject.getProperty("OnoffCodProcState");
                this.m_onoffCodProcState = unsignedInt8.intValue();
            }
            if (this.m_codCapsBitSet.get(7)) {
                this.m_onoffCodMemIncrement = (UnsignedInt16)rObject.getProperty("OnoffCodMemIncrement");
                unsignedInt8 = (UnsignedInt8)rObject.getProperty("OnoffCodMemState");
                this.m_onoffCodMemState = unsignedInt8.intValue();
            }
            if (this.m_codCapsBitSet.get(2)) {
                this.m_meteredCodProcIncrement = (UnsignedInt16)rObject.getProperty("MeteredCodProcIncrement");
                unsignedInt8 = (UnsignedInt8)rObject.getProperty("MeteredCodProcState");
                this.m_meteredCodProcState = unsignedInt8.intValue();
            }
            if (this.m_codCapsBitSet.get(4)) {
                unsignedInt8 = (UnsignedInt8)rObject.getProperty("TrialCodProcState");
                this.m_trialCodProcState = unsignedInt8.intValue();
            }
            if (this.m_codCapsBitSet.get(5)) {
                unsignedInt8 = (UnsignedInt8)rObject.getProperty("TrialCodMemState");
                this.m_trialCodMemState = unsignedInt8.intValue();
            }
            System.out.println("In PICodMethProv ... runtimeCapsBitSet = " + this.m_runtimeCapsBitSet);
            System.out.println("In PICodMethProv ... codCapsBitSet = " + this.m_codCapsBitSet);
            System.out.println("In PICodMethProv ... m_onoffCodProcIncrement = " + this.m_onoffCodProcIncrement);
            System.out.println("In PICodMethProv ... m_onoffCodMemIncrement = " + this.m_onoffCodMemIncrement);
            System.out.println("In PICodMethProv ... m_meteredCodProcIncrement = " + this.m_meteredCodProcIncrement);
            System.out.println("In PICodMethProv ... m_onoffCodProcState = " + this.m_onoffCodProcState);
            System.out.println("In PICodMethProv ... m_onoffCodMemState = " + this.m_onoffCodMemState);
            System.out.println("In PICodMethProv ... m_meteredCodProcState = " + this.m_meteredCodProcState);
            System.out.println("In PICodMethProv ... m_trialCodProcState = " + this.m_trialCodProcState);
            System.out.println("In PICodMethProv ... m_trialCodMemState = " + this.m_trialCodMemState);
        }
        catch (Throwable throwable) {
            if (!bl) {
                throwable.printStackTrace();
            }
            if (throwable instanceof PIHscServerException) {
                throw (PIHscServerException)throwable;
            }
            throw new PIHscServerException(throwable.getMessage());
        }
        if (METH_GET_COD_PROCESSOR_INFO.equalsIgnoreCase(string)) {
            if (1 != n && 17 != n && 16 != n) {
                throw new PIHscServerException("9010");
            }
            this.getCodProcessorInfo(fspCmdHelper, vector2);
        } else if (METH_GET_ONOFF_COD_PROCESSOR_INFO.equalsIgnoreCase(string)) {
            if (1 != n && 17 != n && 16 != n) {
                throw new PIHscServerException("9010");
            }
            if (!this.m_runtimeCapsBitSet.get(29)) {
                throw new PIHscServerException("9000");
            }
            if (!this.m_codCapsBitSet.get(6)) {
                throw new PIHscServerException("900B");
            }
            this.getOnoffCodProcessorInfo(fspCmdHelper, vector2);
        } else if (METH_GET_METERED_COD_PROCESSOR_INFO.equalsIgnoreCase(string)) {
            if (1 != n && 17 != n && 16 != n) {
                throw new PIHscServerException("9010");
            }
            if (!this.m_runtimeCapsBitSet.get(29)) {
                throw new PIHscServerException("9000");
            }
            if (!this.m_codCapsBitSet.get(2)) {
                throw new PIHscServerException("900D");
            }
            this.getMeteredCodProcessorInfo(fspCmdHelper, vector2);
        } else if (METH_GET_TRIAL_COD_PROCESSOR_INFO.equalsIgnoreCase(string)) {
            if (1 != n && 17 != n && 16 != n) {
                throw new PIHscServerException("9010");
            }
            if (!this.m_runtimeCapsBitSet.get(29)) {
                throw new PIHscServerException("9000");
            }
            if (!this.m_codCapsBitSet.get(4)) {
                throw new PIHscServerException("900E");
            }
            this.getTrialCodProcessorInfo(fspCmdHelper, vector2);
        } else if (METH_GET_COD_MEMORY_INFO.equalsIgnoreCase(string)) {
            if (1 != n && 17 != n && 16 != n) {
                throw new PIHscServerException("9010");
            }
            this.getCodMemoryInfo(fspCmdHelper, vector2);
        } else if (METH_GET_ONOFF_COD_MEMORY_INFO.equalsIgnoreCase(string)) {
            if (1 != n && 17 != n && 16 != n) {
                throw new PIHscServerException("9010");
            }
            if (!this.m_runtimeCapsBitSet.get(29)) {
                throw new PIHscServerException("9000");
            }
            if (!this.m_codCapsBitSet.get(7)) {
                throw new PIHscServerException("900C");
            }
            this.getOnoffCodMemoryInfo(fspCmdHelper, vector2);
        } else if (METH_GET_TRIAL_COD_MEMORY_INFO.equalsIgnoreCase(string)) {
            if (1 != n && 17 != n && 16 != n) {
                throw new PIHscServerException("9010");
            }
            if (!this.m_runtimeCapsBitSet.get(29)) {
                throw new PIHscServerException("9000");
            }
            if (!this.m_codCapsBitSet.get(5)) {
                throw new PIHscServerException("900F");
            }
            this.getTrialCodMemoryInfo(fspCmdHelper, vector2);
        } else if (METH_GET_ONOFF_COD_PROC_BILLING_INFO.equalsIgnoreCase(string)) {
            if (1 != n && 17 != n && 16 != n) {
                throw new PIHscServerException("9010");
            }
            if (!this.m_runtimeCapsBitSet.get(29)) {
                throw new PIHscServerException("9000");
            }
            if (!this.m_codCapsBitSet.get(6)) {
                throw new PIHscServerException("900B");
            }
            this.getOnoffCodProcBillingInfo(fspCmdHelper, vector2);
        } else if (METH_GET_ONOFF_COD_MEM_BILLING_INFO.equalsIgnoreCase(string)) {
            if (1 != n && 17 != n && 16 != n) {
                throw new PIHscServerException("9010");
            }
            if (!this.m_runtimeCapsBitSet.get(29)) {
                throw new PIHscServerException("9000");
            }
            if (!this.m_codCapsBitSet.get(7)) {
                throw new PIHscServerException("900C");
            }
            this.getOnoffCodMemBillingInfo(fspCmdHelper, vector2);
        } else if (METH_GET_COD_ORDER_INFO.equalsIgnoreCase(string)) {
            if (1 != n && 17 != n && 16 != n) {
                throw new PIHscServerException("9010");
            }
            if (!this.m_runtimeCapsBitSet.get(29)) {
                throw new PIHscServerException("9000");
            }
            this.getCodOrderInfo(fspCmdHelper, vector, vector2);
        } else if (METH_MANAGE_ONOFF_PROCESSORS.equalsIgnoreCase(string)) {
            if (1 != n && 17 != n && 16 != n) {
                throw new PIHscServerException("9010");
            }
            if (!this.m_runtimeCapsBitSet.get(29)) {
                throw new PIHscServerException("9000");
            }
            if (!this.m_codCapsBitSet.get(6)) {
                throw new PIHscServerException("900B");
            }
            this.manageOnoffProcessors(fspCmdHelper, vector, vector2);
        } else if (METH_MANAGE_METERED_PROCESSORS.equalsIgnoreCase(string)) {
            if (1 != n && 17 != n && 16 != n) {
                throw new PIHscServerException("9010");
            }
            if (!this.m_runtimeCapsBitSet.get(29)) {
                throw new PIHscServerException("9000");
            }
            if (!this.m_codCapsBitSet.get(2)) {
                throw new PIHscServerException("900D");
            }
            this.manageMeteredProcessors(fspCmdHelper, vector, vector2);
        } else if (METH_MANAGE_ONOFF_MEMORY.equalsIgnoreCase(string)) {
            if (1 != n && 17 != n && 16 != n) {
                throw new PIHscServerException("9010");
            }
            if (!this.m_runtimeCapsBitSet.get(29)) {
                throw new PIHscServerException("9000");
            }
            if (!this.m_codCapsBitSet.get(7)) {
                throw new PIHscServerException("900C");
            }
            this.manageOnoffMemory(fspCmdHelper, vector, vector2);
        } else if (METH_DISABLE_TRIAL_RESOURCES.equalsIgnoreCase(string)) {
            if (1 != n && 17 != n && 16 != n) {
                throw new PIHscServerException("9010");
            }
            if (!this.m_runtimeCapsBitSet.get(29)) {
                throw new PIHscServerException("9000");
            }
            this.disableTrialResources(fspCmdHelper, vector, vector2);
        } else if (METH_SET_COD_KEY.equalsIgnoreCase(string)) {
            if (1 != n && 17 != n && 16 != n) {
                throw new PIHscServerException("9010");
            }
            if (!this.m_runtimeCapsBitSet.get(29)) {
                throw new PIHscServerException("9000");
            }
            this.setCodKey(fspCmdHelper, vector, vector2);
        } else if (METH_SET_COD_CTA_VALUE.equalsIgnoreCase(string)) {
            this.setCodCtaValue(fspCmdHelper, vector);
        } else if (METH_SET_COD_RECOVERY_COMPLETE.equalsIgnoreCase(string)) {
            this.setCodRecoveryComplete(fspCmdHelper, vector);
        } else if (METH_GET_COD_HISTORY_LOG.equalsIgnoreCase(string)) {
            if (1 != n && 17 != n && 16 != n) {
                throw new PIHscServerException("9010");
            }
            if (!this.m_runtimeCapsBitSet.get(29)) {
                throw new PIHscServerException("9000");
            }
            this.getCodHistoryLog(fspCmdHelper, vector2);
        } else if (METH_GET_SHARED_PROCESSOR_POOL_UTILIZATION.equalsIgnoreCase(string)) {
            if (1 != n && 17 != n && 16 != n) {
                throw new PIHscServerException("9010");
            }
            if (!this.m_codCapsBitSet.get(2)) {
                throw new PIHscServerException("900D");
            }
            this.getSharedProcessorPoolUtilization(fspCmdHelper, vector2);
        } else {
            throw new PIHscServerException("1581", new String[]{string}, null);
        }
        return cIMValue;
    }

    private void getCodProcessorInfo(FspCmdHelper fspCmdHelper, Vector vector) throws PIHscServerException {
        try {
            FspCodProcessorInfo fspCodProcessorInfo = fspCmdHelper.getCodProcessorInfo();
            vector.setSize(3);
            if (CALL_BY_VALUE) {
                vector.setElementAt(new CIMValue((Object)fspCodProcessorInfo.getTotalInstalledProcs(), new CIMDataType(5)), 0);
                vector.setElementAt(new CIMValue((Object)fspCodProcessorInfo.getPermLicensedProcs(), new CIMDataType(5)), 1);
                vector.setElementAt(new CIMValue((Object)fspCodProcessorInfo.getDeconfiguredProcs(), new CIMDataType(5)), 2);
            } else {
                vector.setElementAt(new CIMProperty("TotalInstalledProcs", new CIMValue((Object)fspCodProcessorInfo.getTotalInstalledProcs(), new CIMDataType(5))), 0);
                vector.setElementAt(new CIMProperty("PermLicensedProcs", new CIMValue((Object)fspCodProcessorInfo.getPermLicensedProcs(), new CIMDataType(5))), 1);
                vector.setElementAt(new CIMProperty("DeconfiguredProcs", new CIMValue((Object)fspCodProcessorInfo.getDeconfiguredProcs(), new CIMDataType(5))), 2);
            }
        }
        catch (PIHscCmdMgrException pIHscCmdMgrException) {
            if (!pIHscCmdMgrException.alreadyLogged()) {
                HSCLogUtils.serverLog(pIHscCmdMgrException, HSCLogUtils._CECClassLogInfo);
                pIHscCmdMgrException.setAlreadyLogged(true);
            }
            if (pIHscCmdMgrException.isExtendedError()) {
                CmdExtendedErrorList cmdExtendedErrorList = pIHscCmdMgrException.getExtendedError();
                CmdExtendedError cmdExtendedError = cmdExtendedErrorList.getErrorAt(0);
                String[] stringArray = PICodMethProcessor.getCodExtendedErrorMsg(cmdExtendedError);
                String string = stringArray[0];
                if (stringArray[1] == null) {
                    throw new PIHscServerException(string, pIHscCmdMgrException);
                }
                String[] stringArray2 = new String[]{stringArray[1]};
                throw new PIHscServerException(string, stringArray2, pIHscCmdMgrException);
            }
            if (pIHscCmdMgrException.getStatus() == 32808) {
                throw new PIHscServerException("9010", pIHscCmdMgrException);
            }
            throw new PIHscServerException("9001", pIHscCmdMgrException);
        }
    }

    private void getOnoffCodProcessorInfo(FspCmdHelper fspCmdHelper, Vector vector) throws PIHscServerException {
        try {
            FspOnoffCodProcessorInfo fspOnoffCodProcessorInfo = fspCmdHelper.getOnoffCodProcessorInfo();
            vector.setSize(7);
            if (CALL_BY_VALUE) {
                vector.setElementAt(new CIMValue((Object)fspOnoffCodProcessorInfo.getOnoffCurrProcsInUse(), new CIMDataType(5)), 0);
                vector.setElementAt(new CIMValue((Object)fspOnoffCodProcessorInfo.getOnoffUnlicensedProcsAvail(), new CIMDataType(5)), 1);
                vector.setElementAt(new CIMValue((Object)fspOnoffCodProcessorInfo.getNumUnreturnedOnoffProcsInUse(), new CIMDataType(5)), 2);
                vector.setElementAt(new CIMValue((Object)fspOnoffCodProcessorInfo.getOnoffEnabledProcDaysLeft(), new CIMDataType(3)), 3);
                vector.setElementAt(new CIMValue((Object)fspOnoffCodProcessorInfo.getOnoffActivatedProcDaysLeft(), new CIMDataType(3)), 4);
                vector.setElementAt(new CIMValue((Object)fspOnoffCodProcessorInfo.getOnoffProcHoursLeft(), new CIMDataType(1)), 5);
                vector.setElementAt(new CIMValue((Object)fspOnoffCodProcessorInfo.getOnoffProcState(), new CIMDataType(1)), 6);
            } else {
                vector.setElementAt(new CIMProperty("OnoffCurrProcsInUse", new CIMValue((Object)fspOnoffCodProcessorInfo.getOnoffCurrProcsInUse(), new CIMDataType(5))), 0);
                vector.setElementAt(new CIMProperty("OnoffUnlicensedProcsAvail", new CIMValue((Object)fspOnoffCodProcessorInfo.getOnoffUnlicensedProcsAvail(), new CIMDataType(5))), 1);
                vector.setElementAt(new CIMProperty("NumUnreturnedOnoffProcsInUse", new CIMValue((Object)fspOnoffCodProcessorInfo.getNumUnreturnedOnoffProcsInUse(), new CIMDataType(5))), 2);
                vector.setElementAt(new CIMProperty("OnoffEnabledProcDaysLeft", new CIMValue((Object)fspOnoffCodProcessorInfo.getOnoffEnabledProcDaysLeft(), new CIMDataType(3))), 3);
                vector.setElementAt(new CIMProperty("OnoffActivatedProcDaysLeft", new CIMValue((Object)fspOnoffCodProcessorInfo.getOnoffActivatedProcDaysLeft(), new CIMDataType(3))), 4);
                vector.setElementAt(new CIMProperty("OnoffProcHoursLeft", new CIMValue((Object)fspOnoffCodProcessorInfo.getOnoffProcHoursLeft(), new CIMDataType(1))), 5);
                vector.setElementAt(new CIMProperty("OnoffProcState", new CIMValue((Object)fspOnoffCodProcessorInfo.getOnoffProcState(), new CIMDataType(1))), 6);
            }
        }
        catch (PIHscCmdMgrException pIHscCmdMgrException) {
            if (!pIHscCmdMgrException.alreadyLogged()) {
                HSCLogUtils.serverLog(pIHscCmdMgrException, HSCLogUtils._CECClassLogInfo);
                pIHscCmdMgrException.setAlreadyLogged(true);
            }
            if (pIHscCmdMgrException.isExtendedError()) {
                CmdExtendedErrorList cmdExtendedErrorList = pIHscCmdMgrException.getExtendedError();
                CmdExtendedError cmdExtendedError = cmdExtendedErrorList.getErrorAt(0);
                String[] stringArray = PICodMethProcessor.getCodExtendedErrorMsg(cmdExtendedError);
                String string = stringArray[0];
                if (stringArray[1] == null) {
                    throw new PIHscServerException(string, pIHscCmdMgrException);
                }
                String[] stringArray2 = new String[]{stringArray[1]};
                throw new PIHscServerException(string, stringArray2, pIHscCmdMgrException);
            }
            if (pIHscCmdMgrException.getStatus() == 32808) {
                throw new PIHscServerException("9010", pIHscCmdMgrException);
            }
            throw new PIHscServerException("9001", pIHscCmdMgrException);
        }
    }

    private void getMeteredCodProcessorInfo(FspCmdHelper fspCmdHelper, Vector vector) throws PIHscServerException {
        try {
            FspMeteredCodProcessorInfo fspMeteredCodProcessorInfo = fspCmdHelper.getMeteredCodProcessorInfo();
            vector.setSize(5);
            if (CALL_BY_VALUE) {
                vector.setElementAt(new CIMValue((Object)fspMeteredCodProcessorInfo.getMeteredCurrProcsInUse(), new CIMDataType(5)), 0);
                vector.setElementAt(new CIMValue((Object)fspMeteredCodProcessorInfo.getMeteredUnlicensedProcsAvail(), new CIMDataType(5)), 1);
                vector.setElementAt(new CIMValue((Object)fspMeteredCodProcessorInfo.getMeteredCurrEnabledDaysLeft(), new CIMDataType(3)), 2);
                vector.setElementAt(new CIMValue((Object)fspMeteredCodProcessorInfo.getMeteredProcState(), new CIMDataType(1)), 3);
                vector.setElementAt(new CIMValue((Object)fspMeteredCodProcessorInfo.getMeteredHoursLeftPerProcList(), new CIMDataType(23)), 4);
            } else {
                vector.setElementAt(new CIMProperty("MeteredCurrProcsInUse", new CIMValue((Object)fspMeteredCodProcessorInfo.getMeteredCurrProcsInUse(), new CIMDataType(5))), 0);
                vector.setElementAt(new CIMProperty("MeteredUnlicensedProcsAvail", new CIMValue((Object)fspMeteredCodProcessorInfo.getMeteredUnlicensedProcsAvail(), new CIMDataType(5))), 1);
                vector.setElementAt(new CIMProperty("MeteredEnabledProcDaysLeft", new CIMValue((Object)fspMeteredCodProcessorInfo.getMeteredCurrEnabledDaysLeft(), new CIMDataType(3))), 2);
                vector.setElementAt(new CIMProperty("MeteredProcState", new CIMValue((Object)fspMeteredCodProcessorInfo.getMeteredProcState(), new CIMDataType(1))), 3);
                vector.setElementAt(new CIMProperty("HoursLeftPerMeteredProc", new CIMValue((Object)fspMeteredCodProcessorInfo.getMeteredHoursLeftPerProcList(), new CIMDataType(23))), 4);
            }
        }
        catch (PIHscCmdMgrException pIHscCmdMgrException) {
            if (!pIHscCmdMgrException.alreadyLogged()) {
                HSCLogUtils.serverLog(pIHscCmdMgrException, HSCLogUtils._CECClassLogInfo);
                pIHscCmdMgrException.setAlreadyLogged(true);
            }
            if (pIHscCmdMgrException.isExtendedError()) {
                CmdExtendedErrorList cmdExtendedErrorList = pIHscCmdMgrException.getExtendedError();
                CmdExtendedError cmdExtendedError = cmdExtendedErrorList.getErrorAt(0);
                String[] stringArray = PICodMethProcessor.getCodExtendedErrorMsg(cmdExtendedError);
                String string = stringArray[0];
                if (stringArray[1] == null) {
                    throw new PIHscServerException(string, pIHscCmdMgrException);
                }
                String[] stringArray2 = new String[]{stringArray[1]};
                throw new PIHscServerException(string, stringArray2, pIHscCmdMgrException);
            }
            if (pIHscCmdMgrException.getStatus() == 32808) {
                throw new PIHscServerException("9010", pIHscCmdMgrException);
            }
            throw new PIHscServerException("9001", pIHscCmdMgrException);
        }
    }

    private void getTrialCodProcessorInfo(FspCmdHelper fspCmdHelper, Vector vector) throws PIHscServerException {
        try {
            FspTrialCodProcessorInfo fspTrialCodProcessorInfo = fspCmdHelper.getTrialCodProcessorInfo();
            vector.setSize(4);
            if (CALL_BY_VALUE) {
                vector.setElementAt(new CIMValue((Object)fspTrialCodProcessorInfo.getTrialCurrProcsInUse(), new CIMDataType(5)), 0);
                vector.setElementAt(new CIMValue((Object)fspTrialCodProcessorInfo.getTrialCurrUnreturnedProcs(), new CIMDataType(5)), 1);
                vector.setElementAt(new CIMValue((Object)fspTrialCodProcessorInfo.getTrialHoursLeft(), new CIMDataType(3)), 2);
                vector.setElementAt(new CIMValue((Object)fspTrialCodProcessorInfo.getTrialProcState(), new CIMDataType(1)), 3);
            } else {
                vector.setElementAt(new CIMProperty("TrialCurrProcsInUse", new CIMValue((Object)fspTrialCodProcessorInfo.getTrialCurrProcsInUse(), new CIMDataType(5))), 0);
                vector.setElementAt(new CIMProperty("TrialProcsUnreturned", new CIMValue((Object)fspTrialCodProcessorInfo.getTrialCurrUnreturnedProcs(), new CIMDataType(5))), 1);
                vector.setElementAt(new CIMProperty("TrialHoursLeft", new CIMValue((Object)fspTrialCodProcessorInfo.getTrialHoursLeft(), new CIMDataType(3))), 2);
                vector.setElementAt(new CIMProperty("TrialProcState", new CIMValue((Object)fspTrialCodProcessorInfo.getTrialProcState(), new CIMDataType(1))), 3);
            }
        }
        catch (PIHscCmdMgrException pIHscCmdMgrException) {
            if (!pIHscCmdMgrException.alreadyLogged()) {
                HSCLogUtils.serverLog(pIHscCmdMgrException, HSCLogUtils._CECClassLogInfo);
                pIHscCmdMgrException.setAlreadyLogged(true);
            }
            if (pIHscCmdMgrException.isExtendedError()) {
                CmdExtendedErrorList cmdExtendedErrorList = pIHscCmdMgrException.getExtendedError();
                CmdExtendedError cmdExtendedError = cmdExtendedErrorList.getErrorAt(0);
                String[] stringArray = PICodMethProcessor.getCodExtendedErrorMsg(cmdExtendedError);
                String string = stringArray[0];
                if (stringArray[1] == null) {
                    throw new PIHscServerException(string, pIHscCmdMgrException);
                }
                String[] stringArray2 = new String[]{stringArray[1]};
                throw new PIHscServerException(string, stringArray2, pIHscCmdMgrException);
            }
            if (pIHscCmdMgrException.getStatus() == 32808) {
                throw new PIHscServerException("9010", pIHscCmdMgrException);
            }
            throw new PIHscServerException("9001", pIHscCmdMgrException);
        }
    }

    private void getCodMemoryInfo(FspCmdHelper fspCmdHelper, Vector vector) throws PIHscServerException {
        try {
            FspCodMemoryInfo fspCodMemoryInfo = fspCmdHelper.getCodMemoryInfo();
            vector.setSize(3);
            if (CALL_BY_VALUE) {
                vector.setElementAt(new CIMValue((Object)fspCodMemoryInfo.getTotalInstalledMem(), new CIMDataType(5)), 0);
                vector.setElementAt(new CIMValue((Object)fspCodMemoryInfo.getPermLicensedMem(), new CIMDataType(5)), 1);
                vector.setElementAt(new CIMValue((Object)fspCodMemoryInfo.getDeconfiguredMem(), new CIMDataType(5)), 2);
            } else {
                vector.setElementAt(new CIMProperty("TotalInstalledMem", new CIMValue((Object)fspCodMemoryInfo.getTotalInstalledMem(), new CIMDataType(5))), 0);
                vector.setElementAt(new CIMProperty("PermLicensedMem", new CIMValue((Object)fspCodMemoryInfo.getPermLicensedMem(), new CIMDataType(5))), 1);
                vector.setElementAt(new CIMProperty("DeconfiguredMem", new CIMValue((Object)fspCodMemoryInfo.getDeconfiguredMem(), new CIMDataType(5))), 2);
            }
        }
        catch (PIHscCmdMgrException pIHscCmdMgrException) {
            if (!pIHscCmdMgrException.alreadyLogged()) {
                HSCLogUtils.serverLog(pIHscCmdMgrException, HSCLogUtils._CECClassLogInfo);
                pIHscCmdMgrException.setAlreadyLogged(true);
            }
            if (pIHscCmdMgrException.isExtendedError()) {
                CmdExtendedErrorList cmdExtendedErrorList = pIHscCmdMgrException.getExtendedError();
                CmdExtendedError cmdExtendedError = cmdExtendedErrorList.getErrorAt(0);
                String[] stringArray = PICodMethProcessor.getCodExtendedErrorMsg(cmdExtendedError);
                String string = stringArray[0];
                if (stringArray[1] == null) {
                    throw new PIHscServerException(string, pIHscCmdMgrException);
                }
                String[] stringArray2 = new String[]{stringArray[1]};
                throw new PIHscServerException(string, stringArray2, pIHscCmdMgrException);
            }
            if (pIHscCmdMgrException.getStatus() == 32808) {
                throw new PIHscServerException("9010", pIHscCmdMgrException);
            }
            throw new PIHscServerException("9001", pIHscCmdMgrException);
        }
    }

    private void getOnoffCodMemoryInfo(FspCmdHelper fspCmdHelper, Vector vector) throws PIHscServerException {
        try {
            FspOnoffCodMemoryInfo fspOnoffCodMemoryInfo = fspCmdHelper.getOnoffCodMemoryInfo();
            vector.setSize(8);
            if (CALL_BY_VALUE) {
                vector.setElementAt(new CIMValue((Object)fspOnoffCodMemoryInfo.getOnoffCurrMemInUse(), new CIMDataType(5)), 0);
                vector.setElementAt(new CIMValue((Object)fspOnoffCodMemoryInfo.getOnoffUnlicensedMemAvail(), new CIMDataType(5)), 1);
                vector.setElementAt(new CIMValue((Object)fspOnoffCodMemoryInfo.getAmtUnreturnedOnoffMemInUse(), new CIMDataType(5)), 2);
                vector.setElementAt(new CIMValue((Object)fspOnoffCodMemoryInfo.getOnoffEnabledMemDaysLeft(), new CIMDataType(3)), 3);
                vector.setElementAt(new CIMValue((Object)fspOnoffCodMemoryInfo.getOnoffActivatedMemDaysLeft(), new CIMDataType(3)), 4);
                vector.setElementAt(new CIMValue((Object)fspOnoffCodMemoryInfo.getOnoffMemHoursLeft(), new CIMDataType(1)), 5);
                vector.setElementAt(new CIMValue((Object)fspOnoffCodMemoryInfo.getOnoffMemState(), new CIMDataType(1)), 6);
                vector.setElementAt(new CIMValue((Object)fspOnoffCodMemoryInfo.getOnoffMemoryUnit(), new CIMDataType(3)), 7);
            } else {
                vector.setElementAt(new CIMProperty("OnoffCurrMemInUse", new CIMValue((Object)fspOnoffCodMemoryInfo.getOnoffCurrMemInUse(), new CIMDataType(5))), 0);
                vector.setElementAt(new CIMProperty("OnoffUnlicensedMemAvail", new CIMValue((Object)fspOnoffCodMemoryInfo.getOnoffUnlicensedMemAvail(), new CIMDataType(5))), 1);
                vector.setElementAt(new CIMProperty("AmtUnreturnedOnoffMemInUse", new CIMValue((Object)fspOnoffCodMemoryInfo.getAmtUnreturnedOnoffMemInUse(), new CIMDataType(5))), 2);
                vector.setElementAt(new CIMProperty("OnoffEnabledMemunitdaysLeft", new CIMValue((Object)fspOnoffCodMemoryInfo.getOnoffEnabledMemDaysLeft(), new CIMDataType(3))), 3);
                vector.setElementAt(new CIMProperty("OnoffActivatedMemunitdaysLeft", new CIMValue((Object)fspOnoffCodMemoryInfo.getOnoffActivatedMemDaysLeft(), new CIMDataType(3))), 4);
                vector.setElementAt(new CIMProperty("OnoffMemunitdayHoursLeft", new CIMValue((Object)fspOnoffCodMemoryInfo.getOnoffMemHoursLeft(), new CIMDataType(1))), 5);
                vector.setElementAt(new CIMProperty("OnoffMemState", new CIMValue((Object)fspOnoffCodMemoryInfo.getOnoffMemState(), new CIMDataType(1))), 6);
                vector.setElementAt(new CIMProperty("OnoffMemoryUnit", new CIMValue((Object)fspOnoffCodMemoryInfo.getOnoffMemoryUnit(), new CIMDataType(3))), 7);
            }
        }
        catch (PIHscCmdMgrException pIHscCmdMgrException) {
            if (!pIHscCmdMgrException.alreadyLogged()) {
                HSCLogUtils.serverLog(pIHscCmdMgrException, HSCLogUtils._CECClassLogInfo);
                pIHscCmdMgrException.setAlreadyLogged(true);
            }
            if (pIHscCmdMgrException.isExtendedError()) {
                CmdExtendedErrorList cmdExtendedErrorList = pIHscCmdMgrException.getExtendedError();
                CmdExtendedError cmdExtendedError = cmdExtendedErrorList.getErrorAt(0);
                String[] stringArray = PICodMethProcessor.getCodExtendedErrorMsg(cmdExtendedError);
                String string = stringArray[0];
                if (stringArray[1] == null) {
                    throw new PIHscServerException(string, pIHscCmdMgrException);
                }
                String[] stringArray2 = new String[]{stringArray[1]};
                throw new PIHscServerException(string, stringArray2, pIHscCmdMgrException);
            }
            if (pIHscCmdMgrException.getStatus() == 32808) {
                throw new PIHscServerException("9010", pIHscCmdMgrException);
            }
            throw new PIHscServerException("9001", pIHscCmdMgrException);
        }
    }

    private void getTrialCodMemoryInfo(FspCmdHelper fspCmdHelper, Vector vector) throws PIHscServerException {
        try {
            FspTrialCodMemoryInfo fspTrialCodMemoryInfo = fspCmdHelper.getTrialCodMemoryInfo();
            vector.setSize(4);
            if (CALL_BY_VALUE) {
                vector.setElementAt(new CIMValue((Object)fspTrialCodMemoryInfo.getTrialCurrMemInUse(), new CIMDataType(5)), 0);
                vector.setElementAt(new CIMValue((Object)fspTrialCodMemoryInfo.getTrialCurrMemUnreturned(), new CIMDataType(5)), 1);
                vector.setElementAt(new CIMValue((Object)fspTrialCodMemoryInfo.getTrialHoursLeft(), new CIMDataType(3)), 2);
                vector.setElementAt(new CIMValue((Object)fspTrialCodMemoryInfo.getTrialMemState(), new CIMDataType(1)), 3);
            } else {
                vector.setElementAt(new CIMProperty("TrialCurrMemInUse", new CIMValue((Object)fspTrialCodMemoryInfo.getTrialCurrMemInUse(), new CIMDataType(5))), 0);
                vector.setElementAt(new CIMProperty("TrialMemUnreturned", new CIMValue((Object)fspTrialCodMemoryInfo.getTrialCurrMemUnreturned(), new CIMDataType(5))), 1);
                vector.setElementAt(new CIMProperty("TrialHoursLeft", new CIMValue((Object)fspTrialCodMemoryInfo.getTrialHoursLeft(), new CIMDataType(3))), 2);
                vector.setElementAt(new CIMProperty("TrialMemState", new CIMValue((Object)fspTrialCodMemoryInfo.getTrialMemState(), new CIMDataType(1))), 3);
            }
        }
        catch (PIHscCmdMgrException pIHscCmdMgrException) {
            if (!pIHscCmdMgrException.alreadyLogged()) {
                HSCLogUtils.serverLog(pIHscCmdMgrException, HSCLogUtils._CECClassLogInfo);
                pIHscCmdMgrException.setAlreadyLogged(true);
            }
            if (pIHscCmdMgrException.isExtendedError()) {
                CmdExtendedErrorList cmdExtendedErrorList = pIHscCmdMgrException.getExtendedError();
                CmdExtendedError cmdExtendedError = cmdExtendedErrorList.getErrorAt(0);
                String[] stringArray = PICodMethProcessor.getCodExtendedErrorMsg(cmdExtendedError);
                String string = stringArray[0];
                if (stringArray[1] == null) {
                    throw new PIHscServerException(string, pIHscCmdMgrException);
                }
                String[] stringArray2 = new String[]{stringArray[1]};
                throw new PIHscServerException(string, stringArray2, pIHscCmdMgrException);
            }
            if (pIHscCmdMgrException.getStatus() == 32808) {
                throw new PIHscServerException("9010", pIHscCmdMgrException);
            }
            throw new PIHscServerException("9001", pIHscCmdMgrException);
        }
    }

    private void getOnoffCodProcBillingInfo(FspCmdHelper fspCmdHelper, Vector vector) throws PIHscServerException {
        try {
            FspOnoffCodBillingInfo fspOnoffCodBillingInfo = fspCmdHelper.getOnoffCodProcBillingInfo();
            vector.setSize(2);
            if (CALL_BY_VALUE) {
                vector.setElementAt(new CIMValue((Object)fspOnoffCodBillingInfo.getFormat(), new CIMDataType(1)), 0);
                vector.setElementAt(new CIMValue((Object)fspOnoffCodBillingInfo.getProcBillingInfoList(), new CIMDataType(29)), 1);
            } else {
                vector.setElementAt(new CIMProperty("Format", new CIMValue((Object)fspOnoffCodBillingInfo.getFormat(), new CIMDataType(1))), 0);
                vector.setElementAt(new CIMProperty("OnoffCodProcBillingInfoList", new CIMValue((Object)fspOnoffCodBillingInfo.getProcBillingInfoList(), new CIMDataType(29))), 1);
            }
        }
        catch (PIHscCmdMgrException pIHscCmdMgrException) {
            if (!pIHscCmdMgrException.alreadyLogged()) {
                HSCLogUtils.serverLog(pIHscCmdMgrException, HSCLogUtils._CECClassLogInfo);
                pIHscCmdMgrException.setAlreadyLogged(true);
            }
            if (pIHscCmdMgrException.isExtendedError()) {
                CmdExtendedErrorList cmdExtendedErrorList = pIHscCmdMgrException.getExtendedError();
                CmdExtendedError cmdExtendedError = cmdExtendedErrorList.getErrorAt(0);
                String[] stringArray = PICodMethProcessor.getCodExtendedErrorMsg(cmdExtendedError);
                String string = stringArray[0];
                if (stringArray[1] == null) {
                    throw new PIHscServerException(string, pIHscCmdMgrException);
                }
                String[] stringArray2 = new String[]{stringArray[1]};
                throw new PIHscServerException(string, stringArray2, pIHscCmdMgrException);
            }
            if (pIHscCmdMgrException.getStatus() == 32808) {
                throw new PIHscServerException("9010", pIHscCmdMgrException);
            }
            throw new PIHscServerException("9001", pIHscCmdMgrException);
        }
    }

    private void getOnoffCodMemBillingInfo(FspCmdHelper fspCmdHelper, Vector vector) throws PIHscServerException {
        try {
            FspOnoffCodBillingInfo fspOnoffCodBillingInfo = fspCmdHelper.getOnoffCodMemBillingInfo();
            vector.setSize(2);
            if (CALL_BY_VALUE) {
                vector.setElementAt(new CIMValue((Object)fspOnoffCodBillingInfo.getFormat(), new CIMDataType(1)), 0);
                vector.setElementAt(new CIMValue((Object)fspOnoffCodBillingInfo.getMemBillingInfoList(), new CIMDataType(29)), 1);
            } else {
                vector.setElementAt(new CIMProperty("Format", new CIMValue((Object)fspOnoffCodBillingInfo.getFormat(), new CIMDataType(1))), 0);
                vector.setElementAt(new CIMProperty("OnoffCodMemBillingInfoList", new CIMValue((Object)fspOnoffCodBillingInfo.getMemBillingInfoList(), new CIMDataType(29))), 1);
            }
        }
        catch (PIHscCmdMgrException pIHscCmdMgrException) {
            if (!pIHscCmdMgrException.alreadyLogged()) {
                HSCLogUtils.serverLog(pIHscCmdMgrException, HSCLogUtils._CECClassLogInfo);
                pIHscCmdMgrException.setAlreadyLogged(true);
            }
            if (pIHscCmdMgrException.isExtendedError()) {
                CmdExtendedErrorList cmdExtendedErrorList = pIHscCmdMgrException.getExtendedError();
                CmdExtendedError cmdExtendedError = cmdExtendedErrorList.getErrorAt(0);
                String[] stringArray = PICodMethProcessor.getCodExtendedErrorMsg(cmdExtendedError);
                String string = stringArray[0];
                if (stringArray[1] == null) {
                    throw new PIHscServerException(string, pIHscCmdMgrException);
                }
                String[] stringArray2 = new String[]{stringArray[1]};
                throw new PIHscServerException(string, stringArray2, pIHscCmdMgrException);
            }
            if (pIHscCmdMgrException.getStatus() == 32808) {
                throw new PIHscServerException("9010", pIHscCmdMgrException);
            }
            throw new PIHscServerException("9001", pIHscCmdMgrException);
        }
    }

    private void getCodOrderInfo(FspCmdHelper fspCmdHelper, Vector vector, Vector vector2) throws PIHscServerException {
        try {
            CIMProperty cIMProperty = (CIMProperty)vector.elementAt(0);
            UnsignedInt8 unsignedInt8 = (UnsignedInt8)cIMProperty.getValue().getValue();
            cIMProperty = (CIMProperty)vector.elementAt(1);
            UnsignedInt8 unsignedInt82 = (UnsignedInt8)cIMProperty.getValue().getValue();
            if (unsignedInt82.intValue() == 1 && unsignedInt8.intValue() == 1 && !this.m_codCapsBitSet.get(0)) {
                throw new PIHscServerException("9009");
            }
            if (unsignedInt82.intValue() == 1 && unsignedInt8.intValue() == 2 && !this.m_codCapsBitSet.get(6)) {
                throw new PIHscServerException("900B");
            }
            if (unsignedInt82.intValue() == 1 && unsignedInt8.intValue() == 4 && !this.m_codCapsBitSet.get(4)) {
                throw new PIHscServerException("900E");
            }
            if (unsignedInt82.intValue() == 1 && unsignedInt8.intValue() == 5 && !this.m_codCapsBitSet.get(4)) {
                throw new PIHscServerException("900E");
            }
            if (unsignedInt82.intValue() == 1 && unsignedInt8.intValue() == 3 && !this.m_codCapsBitSet.get(2)) {
                throw new PIHscServerException("900D");
            }
            if (unsignedInt82.intValue() == 2 && unsignedInt8.intValue() == 1 && !this.m_codCapsBitSet.get(1)) {
                throw new PIHscServerException("900A");
            }
            if (unsignedInt82.intValue() == 2 && unsignedInt8.intValue() == 2 && !this.m_codCapsBitSet.get(7)) {
                throw new PIHscServerException("900C");
            }
            if (unsignedInt82.intValue() == 2 && unsignedInt8.intValue() == 4 && !this.m_codCapsBitSet.get(5)) {
                throw new PIHscServerException("900F");
            }
            if (unsignedInt82.intValue() == 2 && unsignedInt8.intValue() == 5 && !this.m_codCapsBitSet.get(5)) {
                throw new PIHscServerException("900F");
            }
            FspCodOrderInfo fspCodOrderInfo = fspCmdHelper.getCodOrderInfo(unsignedInt8, unsignedInt82);
            vector2.setSize(2);
            if (CALL_BY_VALUE) {
                vector2.setElementAt(new CIMValue((Object)fspCodOrderInfo.getFormat(), new CIMDataType(1)), 0);
                vector2.setElementAt(new CIMValue((Object)fspCodOrderInfo.getOrderInfoList(), new CIMDataType(29)), 1);
            } else {
                vector2.setElementAt(new CIMProperty("Format", new CIMValue((Object)fspCodOrderInfo.getFormat(), new CIMDataType(1))), 0);
                vector2.setElementAt(new CIMProperty("CodOrderInfoList", new CIMValue((Object)fspCodOrderInfo.getOrderInfoList(), new CIMDataType(29))), 1);
            }
        }
        catch (PIHscCmdMgrException pIHscCmdMgrException) {
            if (!pIHscCmdMgrException.alreadyLogged()) {
                HSCLogUtils.serverLog(pIHscCmdMgrException, HSCLogUtils._CECClassLogInfo);
                pIHscCmdMgrException.setAlreadyLogged(true);
            }
            if (pIHscCmdMgrException.isExtendedError()) {
                CmdExtendedErrorList cmdExtendedErrorList = pIHscCmdMgrException.getExtendedError();
                CmdExtendedError cmdExtendedError = cmdExtendedErrorList.getErrorAt(0);
                String[] stringArray = PICodMethProcessor.getCodExtendedErrorMsg(cmdExtendedError);
                String string = stringArray[0];
                if (stringArray[1] == null) {
                    throw new PIHscServerException(string, pIHscCmdMgrException);
                }
                String[] stringArray2 = new String[]{stringArray[1]};
                throw new PIHscServerException(string, stringArray2, pIHscCmdMgrException);
            }
            if (pIHscCmdMgrException.getStatus() == 32808) {
                throw new PIHscServerException("9010", pIHscCmdMgrException);
            }
            throw new PIHscServerException("9001", pIHscCmdMgrException);
        }
    }

    private void manageOnoffProcessors(FspCmdHelper fspCmdHelper, Vector vector, Vector vector2) throws PIHscServerException {
        CIMProperty cIMProperty = (CIMProperty)vector.elementAt(0);
        UnsignedInt32 unsignedInt32 = (UnsignedInt32)cIMProperty.getValue().getValue();
        cIMProperty = (CIMProperty)vector.elementAt(1);
        UnsignedInt32 unsignedInt322 = (UnsignedInt32)cIMProperty.getValue().getValue();
        int n = unsignedInt32.intValue();
        if (n != 0) {
            if (this.m_onoffCodProcState == 4) {
                throw new PIHscServerException("9031");
            }
        } else if (this.m_onoffCodProcState != 2) {
            throw new PIHscServerException("9033");
        }
        int n2 = this.m_onoffCodProcIncrement.intValue();
        int n3 = n2 / 100;
        if (n % n2 != 0) {
            throw new PIHscServerException("902F", new String[]{Integer.toString(n3)}, null);
        }
        try {
            fspCmdHelper.manageOnoffProcessors(unsignedInt32, unsignedInt322);
        }
        catch (PIHscCmdMgrException pIHscCmdMgrException) {
            if (!pIHscCmdMgrException.alreadyLogged()) {
                HSCLogUtils.serverLog(pIHscCmdMgrException, HSCLogUtils._CECClassLogInfo);
                pIHscCmdMgrException.setAlreadyLogged(true);
            }
            if (pIHscCmdMgrException.isExtendedError()) {
                CmdExtendedErrorList cmdExtendedErrorList = pIHscCmdMgrException.getExtendedError();
                CmdExtendedError cmdExtendedError = cmdExtendedErrorList.getErrorAt(0);
                long l = cmdExtendedError.extractErrorCode();
                if (l == 0x40001001L) {
                    throw new PIHscServerException("9015");
                }
                if (l == 1073750017L) {
                    throw new PIHscServerException("9001");
                }
                if (l == 0x40002002L) {
                    if (n == 0) {
                        throw new PIHscServerException("9048", pIHscCmdMgrException);
                    }
                    throw new PIHscServerException("9048", pIHscCmdMgrException);
                }
                if (l == 1073750030L) {
                    throw new PIHscServerException("9001", pIHscCmdMgrException);
                }
                if (l == 1073750031L) {
                    if (n == 0) {
                        throw new PIHscServerException("9035", pIHscCmdMgrException);
                    }
                    throw new PIHscServerException("902B", pIHscCmdMgrException);
                }
                if (l == 1073750032L) {
                    throw new PIHscServerException("903E", pIHscCmdMgrException);
                }
                if (l == 1073750033L) {
                    throw new PIHscServerException("902D", pIHscCmdMgrException);
                }
                if (l == 1073750038L) {
                    throw new PIHscServerException("9026", pIHscCmdMgrException);
                }
                if (l == 1073750039L) {
                    throw new PIHscServerException("9028", pIHscCmdMgrException);
                }
                if (l == 1073754117L) {
                    throw new PIHscServerException("9010");
                }
                if (l == 0x10000001L) {
                    if (n == 0) {
                        throw new PIHscServerException("9033");
                    }
                    throw new PIHscServerException("9001");
                }
                throw new PIHscServerException("9001", pIHscCmdMgrException);
            }
            if (pIHscCmdMgrException.getStatus() == 32808) {
                throw new PIHscServerException("9010", pIHscCmdMgrException);
            }
            throw new PIHscServerException("9001", pIHscCmdMgrException);
        }
    }

    private void manageMeteredProcessors(FspCmdHelper fspCmdHelper, Vector vector, Vector vector2) throws PIHscServerException {
        CIMProperty cIMProperty = (CIMProperty)vector.elementAt(0);
        UnsignedInt32 unsignedInt32 = (UnsignedInt32)cIMProperty.getValue().getValue();
        int n = unsignedInt32.intValue();
        if (n != 0) {
            if (this.m_meteredCodProcState == 3) {
                throw new PIHscServerException("9042");
            }
        } else if (this.m_meteredCodProcState != 2) {
            throw new PIHscServerException("9043");
        }
        int n2 = this.m_meteredCodProcIncrement.intValue();
        int n3 = n2 / 100;
        if (n % n2 != 0) {
            throw new PIHscServerException("902F", new String[]{Integer.toString(n3)}, null);
        }
        try {
            fspCmdHelper.manageMeteredProcessors(unsignedInt32);
        }
        catch (PIHscCmdMgrException pIHscCmdMgrException) {
            if (!pIHscCmdMgrException.alreadyLogged()) {
                HSCLogUtils.serverLog(pIHscCmdMgrException, HSCLogUtils._CECClassLogInfo);
                pIHscCmdMgrException.setAlreadyLogged(true);
            }
            if (pIHscCmdMgrException.isExtendedError()) {
                CmdExtendedErrorList cmdExtendedErrorList = pIHscCmdMgrException.getExtendedError();
                CmdExtendedError cmdExtendedError = cmdExtendedErrorList.getErrorAt(0);
                long l = cmdExtendedError.extractErrorCode();
                if (l == 0x40001001L) {
                    throw new PIHscServerException("9015");
                }
                if (l == 1073750017L) {
                    throw new PIHscServerException("9001");
                }
                if (l == 0x40002002L) {
                    throw new PIHscServerException("9048");
                }
                if (l == 1073750030L) {
                    throw new PIHscServerException("9001");
                }
                if (l == 1073750031L) {
                    throw new PIHscServerException("903D");
                }
                if (l == 1073750032L) {
                    throw new PIHscServerException("9001");
                }
                if (l == 1073750033L) {
                    throw new PIHscServerException("903F");
                }
                if (l == 1073750038L) {
                    throw new PIHscServerException("9040");
                }
                if (l == 1073750039L) {
                    throw new PIHscServerException("9041");
                }
                if (l == 1073754117L) {
                    throw new PIHscServerException("9010");
                }
                throw new PIHscServerException("9001");
            }
            if (pIHscCmdMgrException.getStatus() == 32808) {
                throw new PIHscServerException("9010", pIHscCmdMgrException);
            }
            throw new PIHscServerException("9001", pIHscCmdMgrException);
        }
    }

    private void manageOnoffMemory(FspCmdHelper fspCmdHelper, Vector vector, Vector vector2) throws PIHscServerException {
        CIMProperty cIMProperty = (CIMProperty)vector.elementAt(0);
        UnsignedInt32 unsignedInt32 = (UnsignedInt32)cIMProperty.getValue().getValue();
        cIMProperty = (CIMProperty)vector.elementAt(1);
        UnsignedInt32 unsignedInt322 = (UnsignedInt32)cIMProperty.getValue().getValue();
        int n = unsignedInt32.intValue();
        if (n != 0) {
            if (this.m_onoffCodMemState == 4) {
                throw new PIHscServerException("9032");
            }
        } else if (this.m_onoffCodMemState != 2) {
            throw new PIHscServerException("9034");
        }
        int n2 = this.m_onoffCodMemIncrement.intValue();
        int n3 = n2 / 1024;
        if (n % n2 != 0) {
            throw new PIHscServerException("9030", new String[]{Integer.toString(n3)}, null);
        }
        try {
            fspCmdHelper.manageOnoffMemory(unsignedInt32, unsignedInt322);
        }
        catch (PIHscCmdMgrException pIHscCmdMgrException) {
            if (!pIHscCmdMgrException.alreadyLogged()) {
                HSCLogUtils.serverLog(pIHscCmdMgrException, HSCLogUtils._CECClassLogInfo);
                pIHscCmdMgrException.setAlreadyLogged(true);
            }
            if (pIHscCmdMgrException.isExtendedError()) {
                CmdExtendedErrorList cmdExtendedErrorList = pIHscCmdMgrException.getExtendedError();
                CmdExtendedError cmdExtendedError = cmdExtendedErrorList.getErrorAt(0);
                long l = cmdExtendedError.extractErrorCode();
                if (l == 0x40001001L) {
                    throw new PIHscServerException("9015");
                }
                if (l == 1073750017L) {
                    throw new PIHscServerException("9001");
                }
                if (l == 0x40002002L) {
                    if (n == 0) {
                        throw new PIHscServerException("9049");
                    }
                    throw new PIHscServerException("9049");
                }
                if (l == 1073750030L) {
                    throw new PIHscServerException("9001", pIHscCmdMgrException);
                }
                if (l == 1073750031L) {
                    if (n == 0) {
                        throw new PIHscServerException("9036");
                    }
                    throw new PIHscServerException("902C");
                }
                if (l == 1073750032L) {
                    throw new PIHscServerException("9001");
                }
                if (l == 1073750033L) {
                    throw new PIHscServerException("902E");
                }
                if (l == 1073750038L) {
                    throw new PIHscServerException("9027");
                }
                if (l == 1073750039L) {
                    throw new PIHscServerException("9029");
                }
                if (l == 1073754117L) {
                    throw new PIHscServerException("9010");
                }
                if (l == 0x10000001L) {
                    if (n == 0) {
                        throw new PIHscServerException("9034");
                    }
                    throw new PIHscServerException("9001");
                }
                throw new PIHscServerException("9001");
            }
            if (pIHscCmdMgrException.getStatus() == 32808) {
                throw new PIHscServerException("9010", pIHscCmdMgrException);
            }
            throw new PIHscServerException("9001", pIHscCmdMgrException);
        }
    }

    private void disableTrialResources(FspCmdHelper fspCmdHelper, Vector vector, Vector vector2) throws PIHscServerException {
        CIMProperty cIMProperty = (CIMProperty)vector.elementAt(0);
        UnsignedInt8 unsignedInt8 = (UnsignedInt8)cIMProperty.getValue().getValue();
        if (unsignedInt8.intValue() == 1) {
            if (!this.m_codCapsBitSet.get(4)) {
                throw new PIHscServerException("900E");
            }
            if (this.m_trialCodProcState != 0) {
                throw new PIHscServerException("9037");
            }
        } else if (unsignedInt8.intValue() == 2) {
            if (!this.m_codCapsBitSet.get(5)) {
                throw new PIHscServerException("900F");
            }
            if (this.m_trialCodMemState != 0) {
                throw new PIHscServerException("9038");
            }
        }
        try {
            fspCmdHelper.disableTrialResources(unsignedInt8);
        }
        catch (PIHscCmdMgrException pIHscCmdMgrException) {
            if (!pIHscCmdMgrException.alreadyLogged()) {
                HSCLogUtils.serverLog(pIHscCmdMgrException, HSCLogUtils._CECClassLogInfo);
                pIHscCmdMgrException.setAlreadyLogged(true);
            }
            if (pIHscCmdMgrException.isExtendedError()) {
                CmdExtendedErrorList cmdExtendedErrorList = pIHscCmdMgrException.getExtendedError();
                CmdExtendedError cmdExtendedError = cmdExtendedErrorList.getErrorAt(0);
                long l = cmdExtendedError.extractErrorCode();
                if (l == 0x40001001L) {
                    throw new PIHscServerException("9015");
                }
                if (l == 1073750017L) {
                    throw new PIHscServerException("9001");
                }
                if (l == 0x40002002L) {
                    if (unsignedInt8.intValue() == 1) {
                        throw new PIHscServerException("9039");
                    }
                    throw new PIHscServerException("903A");
                }
                if (l == 1073754117L) {
                    throw new PIHscServerException("9010");
                }
                throw new PIHscServerException("9001");
            }
            if (pIHscCmdMgrException.getStatus() == 32808) {
                throw new PIHscServerException("9010", pIHscCmdMgrException);
            }
            throw new PIHscServerException("9001", pIHscCmdMgrException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setCodKey(FspCmdHelper fspCmdHelper, Vector vector, Vector vector2) throws PIHscServerException {
        String string;
        String string2 = null;
        FspSvrAsyncSubscription fspSvrAsyncSubscription = null;
        Boolean bl = Boolean.TRUE;
        Boolean bl2 = Boolean.FALSE;
        CIMProperty cIMProperty = (CIMProperty)vector.elementAt(0);
        UnsignedInt8 unsignedInt8 = (UnsignedInt8)cIMProperty.getValue().getValue();
        cIMProperty = (CIMProperty)vector.elementAt(1);
        UnsignedInt16 unsignedInt16 = (UnsignedInt16)cIMProperty.getValue().getValue();
        cIMProperty = (CIMProperty)vector.elementAt(2);
        String string3 = (String)cIMProperty.getValue().getValue();
        string3 = string3.trim();
        int n = 300000;
        Properties properties = new Properties();
        int n2 = 0;
        try {
            properties.load(new FileInputStream(TIMEOUT_PROPS_FILE));
            string = properties.getProperty(TIMEOUT_KEY);
            if (string != null) {
                n2 = Integer.parseInt(string);
            }
        }
        catch (Throwable throwable) {
            System.out.println("Error in reading hmc.properties file!");
        }
        if (n2 > 0) {
            n = n2 * 1000;
        }
        System.out.println("timeoutVal: " + n);
        try {
            string = new UnsignedInt8(0);
            this.m_cecInst.setProperty(R50ComputerSystem.Index_CodCodeCompleteStatus, (Object)string);
        }
        catch (RException rException) {
            rException.printStackTrace();
            throw new PIHscServerException("9001", rException);
        }
        int n3 = 0;
        Lock lock = Lock.getInstance("root/ibmhscS1_0", this.m_cecName);
        FspLockHelper fspLockHelper = new FspLockHelper(this.m_cecMgr.getFspLockMgr(), n3);
        try {
            try {
                Object object;
                Object object2;
                int n4;
                fspLockHelper.addCecLock(this.m_cecObjId);
                fspLockHelper.addCecCoDCodeLock(this.m_cecObjId, 64, false);
                fspLockHelper.lock();
                boolean bl3 = false;
                fspSvrAsyncSubscription = this.m_cecMgr.subscribeSvrEvent(1, 0, n);
                System.out.println("SETTING COD KEY!");
                FspCodInfo fspCodInfo = fspCmdHelper.setCodKey(unsignedInt8, unsignedInt16, string3);
                UnsignedInt32 unsignedInt32 = fspCodInfo.getNumProcsToBeActivated();
                UnsignedInt32 unsignedInt322 = fspCodInfo.getAmtMemToBeActivated();
                UnsignedInt16 unsignedInt162 = fspCodInfo.getNumDaysToBeActivatedEnabled();
                UnsignedInt8 unsignedInt82 = fspCodInfo.getCodType();
                UnsignedInt8 unsignedInt83 = fspCodInfo.getCodResourceType();
                UnsignedInt8 unsignedInt84 = fspCodInfo.getEnableDisableVal();
                UnsignedInt8 unsignedInt85 = fspCodInfo.getConfirmationNeededVal();
                UnsignedInt16 unsignedInt163 = fspCodInfo.getConfirmationId();
                bl2 = unsignedInt85.intValue() == 1 ? Boolean.TRUE : Boolean.FALSE;
                if (unsignedInt82.intValue() == 1 && unsignedInt83.intValue() == 1) {
                    int n5 = unsignedInt32.intValue();
                    n4 = n5 / 100;
                    object2 = new UnsignedInt16((int)((short)n4));
                    object = new String[]{object2.toString()};
                    string2 = HSCResourceBundleUtil.encodeNLSMsg("CoDMsgBundle", PERM_PROC_ACTIVATION_ID, null, (String[])object);
                } else if (unsignedInt82.intValue() == 1 && unsignedInt83.intValue() == 2) {
                    int n6 = unsignedInt322.intValue();
                    n4 = n6 / 1024;
                    object2 = new UnsignedInt16((int)((short)n4));
                    object = new String[]{object2.toString()};
                    string2 = HSCResourceBundleUtil.encodeNLSMsg("CoDMsgBundle", PERM_MEM_ACTIVATION_ID, null, (String[])object);
                } else if (unsignedInt82.intValue() == 2) {
                    if (unsignedInt84.intValue() == 0) {
                        string2 = HSCResourceBundleUtil.encodeNLSMsg("CoDMsgBundle", ONOFF_CAPACITY_TERMINATION_ID);
                    } else {
                        String[] stringArray = new String[]{unsignedInt162.toString()};
                        string2 = unsignedInt83.intValue() == 1 ? HSCResourceBundleUtil.encodeNLSMsg("CoDMsgBundle", ONOFF_PROC_ENABLEMENT_ID, null, stringArray) : HSCResourceBundleUtil.encodeNLSMsg("CoDMsgBundle", ONOFF_MEM_ENABLEMENT_ID, null, stringArray);
                    }
                } else if (unsignedInt82.intValue() == 3) {
                    String[] stringArray = new String[]{unsignedInt162.toString()};
                    string2 = HSCResourceBundleUtil.encodeNLSMsg("CoDMsgBundle", METERED_PROC_ENABLEMENT_ID, null, stringArray);
                } else if ((unsignedInt82.intValue() == 4 || unsignedInt82.intValue() == 5) && unsignedInt83.intValue() == 1) {
                    int n7 = unsignedInt32.intValue();
                    n4 = n7 / 100;
                    object2 = new UnsignedInt16((int)((short)n4));
                    object = new String[]{object2.toString(), unsignedInt162.toString()};
                    string2 = HSCResourceBundleUtil.encodeNLSMsg("CoDMsgBundle", TRIAL_PROC_ACTIVATION_ID, null, (String[])object);
                } else if ((unsignedInt82.intValue() == 4 || unsignedInt82.intValue() == 5) && unsignedInt83.intValue() == 2) {
                    int n8 = unsignedInt322.intValue();
                    n4 = n8 / 1024;
                    object2 = new UnsignedInt16((int)((short)n4));
                    object = new String[]{object2.toString(), unsignedInt162.toString()};
                    string2 = HSCResourceBundleUtil.encodeNLSMsg("CoDMsgBundle", TRIAL_MEM_ACTIVATION_ID, null, (String[])object);
                } else {
                    string2 = "A CoD code has been entered.";
                }
                if (unsignedInt85.intValue() == 0) {
                    System.out.println("No confirmation needed - get async event!");
                    System.out.println("Calling getNextEvent!()");
                    byte[] byArray = (byte[])this.m_cecMgr.doLongRunningTask(this, new Object[]{fspSvrAsyncSubscription}, lock);
                    if (byArray == null) {
                        System.out.println("We timed out!");
                        throw new PIHscServerException("9003", null);
                    }
                    System.out.println("payload length: " + byArray.length);
                    PIParseResponse pIParseResponse = new PIParseResponse(byArray);
                    System.out.println("PIParseResponse: " + pIParseResponse);
                    object2 = fspCmdHelper.getCodAsyncEventData(pIParseResponse);
                    object = ((FspCodAsyncEventData)object2).getEventMask();
                    String string4 = "";
                    if (((BitSet)object).get(1)) {
                        System.out.println("Key processing failed in async event!");
                        string4 = HSCResourceBundleUtil.encodeNLSMsg("CoDMsgBundle", "050F");
                        string2 = string2.concat(string4);
                        bl = Boolean.FALSE;
                    } else {
                        if (((BitSet)object).get(0)) {
                            System.out.println("Key Processing succeeded!");
                        }
                        string4 = HSCResourceBundleUtil.encodeNLSMsg("CoDMsgBundle", "050C");
                        string2 = string2.concat(string4);
                        bl = Boolean.TRUE;
                    }
                }
                vector2.setSize(10);
                if (CALL_BY_VALUE) {
                    vector2.setElementAt(new CIMValue((Object)fspCodInfo.getNumProcsToBeActivated(), new CIMDataType(5)), 0);
                    vector2.setElementAt(new CIMValue((Object)fspCodInfo.getAmtMemToBeActivated(), new CIMDataType(5)), 1);
                    vector2.setElementAt(new CIMValue((Object)fspCodInfo.getNumDaysToBeActivatedEnabled(), new CIMDataType(3)), 2);
                    vector2.setElementAt(new CIMValue((Object)fspCodInfo.getCodType(), new CIMDataType(1)), 3);
                    vector2.setElementAt(new CIMValue((Object)fspCodInfo.getCodResourceType(), new CIMDataType(1)), 4);
                    vector2.setElementAt(new CIMValue((Object)fspCodInfo.getEnableDisableVal(), new CIMDataType(1)), 5);
                    vector2.setElementAt(new CIMValue((Object)bl2, new CIMDataType(10)), 6);
                    vector2.setElementAt(new CIMValue((Object)fspCodInfo.getConfirmationId(), new CIMDataType(3)), 7);
                    vector2.setElementAt(new CIMValue((Object)string2, new CIMDataType(9)), 8);
                    vector2.setElementAt(new CIMValue((Object)bl, new CIMDataType(10)), 9);
                }
                vector2.setElementAt(new CIMProperty("ProcsToBeActivated", new CIMValue((Object)fspCodInfo.getNumProcsToBeActivated(), new CIMDataType(5))), 0);
                vector2.setElementAt(new CIMProperty("MemToBeActivated", new CIMValue((Object)fspCodInfo.getAmtMemToBeActivated(), new CIMDataType(5))), 1);
                vector2.setElementAt(new CIMProperty("NumDaysToBeActivatedEnabled", new CIMValue((Object)fspCodInfo.getNumDaysToBeActivatedEnabled(), new CIMDataType(3))), 2);
                vector2.setElementAt(new CIMProperty("CodType", new CIMValue((Object)fspCodInfo.getCodType(), new CIMDataType(1))), 3);
                vector2.setElementAt(new CIMProperty("ResourceType", new CIMValue((Object)fspCodInfo.getCodResourceType(), new CIMDataType(1))), 4);
                vector2.setElementAt(new CIMProperty("EnableDisableVal", new CIMValue((Object)fspCodInfo.getEnableDisableVal(), new CIMDataType(1))), 5);
                vector2.setElementAt(new CIMProperty("ConfirmationNeeded", new CIMValue((Object)bl2, new CIMDataType(10))), 6);
                vector2.setElementAt(new CIMProperty("ConfirmationMsgId", new CIMValue((Object)fspCodInfo.getConfirmationId(), new CIMDataType(3))), 7);
                vector2.setElementAt(new CIMProperty("ReturnMessage", new CIMValue((Object)string2, new CIMDataType(9))), 8);
                vector2.setElementAt(new CIMProperty("CoDCodeCompleteSuccess", new CIMValue((Object)bl, new CIMDataType(10))), 9);
            }
            catch (PIHscCmdMgrException pIHscCmdMgrException) {
                if (!pIHscCmdMgrException.alreadyLogged()) {
                    HSCLogUtils.serverLog(pIHscCmdMgrException, HSCLogUtils._CECClassLogInfo);
                    pIHscCmdMgrException.setAlreadyLogged(true);
                }
                if (!pIHscCmdMgrException.isExtendedError()) {
                    if (pIHscCmdMgrException.getStatus() != 32808) throw new PIHscServerException("9001", pIHscCmdMgrException);
                    throw new PIHscServerException("9010", pIHscCmdMgrException);
                }
                CmdExtendedErrorList cmdExtendedErrorList = pIHscCmdMgrException.getExtendedError();
                CmdExtendedError cmdExtendedError = cmdExtendedErrorList.getErrorAt(0);
                String[] stringArray = PICodMethProcessor.getCodExtendedErrorMsg(cmdExtendedError);
                String string5 = stringArray[0];
                if (stringArray[1] == null) {
                    throw new PIHscServerException(string5, pIHscCmdMgrException);
                }
                String[] stringArray2 = new String[]{stringArray[1]};
                throw new PIHscServerException(string5, stringArray2, pIHscCmdMgrException);
            }
            catch (PIHscServerException pIHscServerException) {
                pIHscServerException.printStackTrace();
                throw pIHscServerException;
            }
            catch (Throwable throwable) {
                System.out.println("Error!");
                throwable.printStackTrace();
                throw new PIHscServerException("9001", throwable);
            }
            Object var34_51 = null;
        }
        catch (Throwable throwable) {
            Object var34_52 = null;
            fspLockHelper.unlock();
            if (fspSvrAsyncSubscription == null) throw throwable;
            fspSvrAsyncSubscription.close();
            throw throwable;
        }
        fspLockHelper.unlock();
        if (fspSvrAsyncSubscription == null) return;
        fspSvrAsyncSubscription.close();
    }

    public Object performLongRunningTask(Object[] objectArray) throws Throwable {
        FspSvrAsyncSubscription fspSvrAsyncSubscription = (FspSvrAsyncSubscription)objectArray[0];
        System.out.println("Calling getNextEvent!()");
        byte[] byArray = fspSvrAsyncSubscription.getNextEvent();
        return byArray;
    }

    private void setCodCtaValue(FspCmdHelper fspCmdHelper, Vector vector) throws PIHscServerException {
        CIMProperty cIMProperty = (CIMProperty)vector.elementAt(0);
        UnsignedInt8 unsignedInt8 = (UnsignedInt8)cIMProperty.getValue().getValue();
        try {
            fspCmdHelper.setCodCtaValue(unsignedInt8);
        }
        catch (PIHscCmdMgrException pIHscCmdMgrException) {
            if (!pIHscCmdMgrException.alreadyLogged()) {
                HSCLogUtils.serverLog(pIHscCmdMgrException, HSCLogUtils._CECClassLogInfo);
                pIHscCmdMgrException.setAlreadyLogged(true);
            }
            if (pIHscCmdMgrException.isExtendedError()) {
                CmdExtendedErrorList cmdExtendedErrorList = pIHscCmdMgrException.getExtendedError();
                CmdExtendedError cmdExtendedError = cmdExtendedErrorList.getErrorAt(0);
                String[] stringArray = PICodMethProcessor.getCodExtendedErrorMsg(cmdExtendedError);
                String string = stringArray[0];
                if (stringArray[1] == null) {
                    throw new PIHscServerException(string, pIHscCmdMgrException);
                }
                String[] stringArray2 = new String[]{stringArray[1]};
                throw new PIHscServerException(string, stringArray2, pIHscCmdMgrException);
            }
            if (pIHscCmdMgrException.getStatus() == 32808) {
                throw new PIHscServerException("9010", pIHscCmdMgrException);
            }
            throw new PIHscServerException("9001", pIHscCmdMgrException);
        }
    }

    private void setCodRecoveryComplete(FspCmdHelper fspCmdHelper, Vector vector) throws PIHscServerException {
        CIMProperty cIMProperty = (CIMProperty)vector.elementAt(0);
        UnsignedInt8 unsignedInt8 = (UnsignedInt8)cIMProperty.getValue().getValue();
        try {
            fspCmdHelper.setCodRecoveryComplete(unsignedInt8);
        }
        catch (PIHscCmdMgrException pIHscCmdMgrException) {
            if (!pIHscCmdMgrException.alreadyLogged()) {
                HSCLogUtils.serverLog(pIHscCmdMgrException, HSCLogUtils._CECClassLogInfo);
                pIHscCmdMgrException.setAlreadyLogged(true);
            }
            if (pIHscCmdMgrException.isExtendedError()) {
                CmdExtendedErrorList cmdExtendedErrorList = pIHscCmdMgrException.getExtendedError();
                CmdExtendedError cmdExtendedError = cmdExtendedErrorList.getErrorAt(0);
                String[] stringArray = PICodMethProcessor.getCodExtendedErrorMsg(cmdExtendedError);
                String string = stringArray[0];
                if (stringArray[1] == null) {
                    throw new PIHscServerException(string, pIHscCmdMgrException);
                }
                String[] stringArray2 = new String[]{stringArray[1]};
                throw new PIHscServerException(string, stringArray2, pIHscCmdMgrException);
            }
            if (pIHscCmdMgrException.getStatus() == 32808) {
                throw new PIHscServerException("9010", pIHscCmdMgrException);
            }
            throw new PIHscServerException("9001", pIHscCmdMgrException);
        }
    }

    private void getCodHistoryLog(FspCmdHelper fspCmdHelper, Vector vector) throws PIHscServerException {
        try {
            String[] stringArray;
            FspCodHistoryLog fspCodHistoryLog = fspCmdHelper.getCodHistoryLog();
            int n = fspCodHistoryLog.getEntryCount().intValue();
            if (n != 0) {
                UnsignedInt16[] unsignedInt16Array = fspCodHistoryLog.getCodMsgIds();
                UnsignedInt16[] unsignedInt16Array2 = fspCodHistoryLog.getMsgParm1s();
                UnsignedInt16[] unsignedInt16Array3 = fspCodHistoryLog.getMsgParm2s();
                stringArray = new String[n];
                for (int i = 0; i < n; ++i) {
                    String[] stringArray2 = new String[]{unsignedInt16Array2[i].toString(), unsignedInt16Array3[i].toString()};
                    stringArray[i] = HSCResourceBundleUtil.encodeNLSMsg("CoDMsgBundle", ByteUtilities.toHexString(unsignedInt16Array[i]), null, stringArray2);
                }
            } else {
                stringArray = new String[]{"The log is empty."};
            }
            vector.setSize(9);
            if (CALL_BY_VALUE) {
                vector.setElementAt(new CIMValue((Object)fspCodHistoryLog.getLogWrappedVal(), new CIMDataType(1)), 0);
                vector.setElementAt(new CIMValue((Object)fspCodHistoryLog.getEntryCount(), new CIMDataType(3)), 1);
                vector.setElementAt(new CIMValue((Object)stringArray, new CIMDataType(29)), 2);
                vector.setElementAt(new CIMValue((Object)fspCodHistoryLog.getTimestampYears(), new CIMDataType(23)), 3);
                vector.setElementAt(new CIMValue((Object)fspCodHistoryLog.getTimestampMonths(), new CIMDataType(21)), 4);
                vector.setElementAt(new CIMValue((Object)fspCodHistoryLog.getTimestampDays(), new CIMDataType(21)), 5);
                vector.setElementAt(new CIMValue((Object)fspCodHistoryLog.getTimestampHours(), new CIMDataType(21)), 6);
                vector.setElementAt(new CIMValue((Object)fspCodHistoryLog.getTimestampMinutes(), new CIMDataType(21)), 7);
                vector.setElementAt(new CIMValue((Object)fspCodHistoryLog.getTimestampSeconds(), new CIMDataType(21)), 8);
            } else {
                vector.setElementAt(new CIMProperty("LogWrapValue", new CIMValue((Object)fspCodHistoryLog.getLogWrappedVal(), new CIMDataType(1))), 0);
                vector.setElementAt(new CIMProperty("EntryCount", new CIMValue((Object)fspCodHistoryLog.getEntryCount(), new CIMDataType(3))), 1);
                vector.setElementAt(new CIMProperty("HistLogEntries", new CIMValue((Object)stringArray, new CIMDataType(29))), 2);
                vector.setElementAt(new CIMProperty("TimestampYearList", new CIMValue((Object)fspCodHistoryLog.getTimestampYears(), new CIMDataType(23))), 3);
                vector.setElementAt(new CIMProperty("TimestampMonthList", new CIMValue((Object)fspCodHistoryLog.getTimestampMonths(), new CIMDataType(21))), 4);
                vector.setElementAt(new CIMProperty("TimestampDayList", new CIMValue((Object)fspCodHistoryLog.getTimestampDays(), new CIMDataType(21))), 5);
                vector.setElementAt(new CIMProperty("TimestampHourList", new CIMValue((Object)fspCodHistoryLog.getTimestampHours(), new CIMDataType(21))), 6);
                vector.setElementAt(new CIMProperty("TimestampMinuteList", new CIMValue((Object)fspCodHistoryLog.getTimestampMinutes(), new CIMDataType(21))), 7);
                vector.setElementAt(new CIMProperty("TimestampSecondList", new CIMValue((Object)fspCodHistoryLog.getTimestampSeconds(), new CIMDataType(21))), 8);
            }
        }
        catch (PIHscCmdMgrException pIHscCmdMgrException) {
            pIHscCmdMgrException.printStackTrace();
            if (!pIHscCmdMgrException.alreadyLogged()) {
                HSCLogUtils.serverLog(pIHscCmdMgrException, HSCLogUtils._CECClassLogInfo);
                pIHscCmdMgrException.setAlreadyLogged(true);
            }
            if (pIHscCmdMgrException.isExtendedError()) {
                CmdExtendedErrorList cmdExtendedErrorList = pIHscCmdMgrException.getExtendedError();
                CmdExtendedError cmdExtendedError = cmdExtendedErrorList.getErrorAt(0);
                String[] stringArray = PICodMethProcessor.getCodExtendedErrorMsg(cmdExtendedError);
                String string = stringArray[0];
                if (stringArray[1] == null) {
                    throw new PIHscServerException(string, pIHscCmdMgrException);
                }
                String[] stringArray3 = new String[]{stringArray[1]};
                throw new PIHscServerException(string, stringArray3, pIHscCmdMgrException);
            }
            if (pIHscCmdMgrException.getStatus() == 32808) {
                throw new PIHscServerException("9010", pIHscCmdMgrException);
            }
            throw new PIHscServerException("9001", pIHscCmdMgrException);
        }
    }

    private void getSharedProcessorPoolUtilization(FspCmdHelper fspCmdHelper, Vector vector) throws PIHscServerException {
        try {
            FspSharedProcPoolUtilization fspSharedProcPoolUtilization = fspCmdHelper.getSharedProcPoolUtilization();
            vector.setSize(11);
            if (CALL_BY_VALUE) {
                vector.setElementAt(new CIMValue((Object)fspSharedProcPoolUtilization.getBaseProcs(), new CIMDataType(5)), 0);
                vector.setElementAt(new CIMValue((Object)fspSharedProcPoolUtilization.getMeteredProcs(), new CIMDataType(5)), 1);
                vector.setElementAt(new CIMValue((Object)fspSharedProcPoolUtilization.getBaseProcsUtilization(), new CIMDataType(3)), 2);
                vector.setElementAt(new CIMValue((Object)fspSharedProcPoolUtilization.getMeteredProcsUtilization(), new CIMDataType(3)), 3);
                vector.setElementAt(new CIMValue((Object)fspSharedProcPoolUtilization.getSampleRate(), new CIMDataType(3)), 4);
                vector.setElementAt(new CIMValue((Object)fspSharedProcPoolUtilization.getTimestampYear(), new CIMDataType(3)), 5);
                vector.setElementAt(new CIMValue((Object)fspSharedProcPoolUtilization.getTimestampMonth(), new CIMDataType(1)), 6);
                vector.setElementAt(new CIMValue((Object)fspSharedProcPoolUtilization.getTimestampDay(), new CIMDataType(1)), 7);
                vector.setElementAt(new CIMValue((Object)fspSharedProcPoolUtilization.getTimestampHour(), new CIMDataType(1)), 8);
                vector.setElementAt(new CIMValue((Object)fspSharedProcPoolUtilization.getTimestampMinute(), new CIMDataType(1)), 9);
                vector.setElementAt(new CIMValue((Object)fspSharedProcPoolUtilization.getTimestampSeconds(), new CIMDataType(1)), 10);
            } else {
                vector.setElementAt(new CIMProperty("BaseProcs", new CIMValue((Object)fspSharedProcPoolUtilization.getBaseProcs(), new CIMDataType(5))), 0);
                vector.setElementAt(new CIMProperty("MeteredProcs", new CIMValue((Object)fspSharedProcPoolUtilization.getMeteredProcs(), new CIMDataType(5))), 1);
                vector.setElementAt(new CIMProperty("BaseProcsUtilization", new CIMValue((Object)fspSharedProcPoolUtilization.getBaseProcsUtilization(), new CIMDataType(3))), 2);
                vector.setElementAt(new CIMProperty("MeteredProcsUtilization", new CIMValue((Object)fspSharedProcPoolUtilization.getMeteredProcsUtilization(), new CIMDataType(3))), 3);
                vector.setElementAt(new CIMProperty("SampleRate", new CIMValue((Object)fspSharedProcPoolUtilization.getSampleRate(), new CIMDataType(3))), 4);
                vector.setElementAt(new CIMProperty("TimestampYear", new CIMValue((Object)fspSharedProcPoolUtilization.getTimestampYear(), new CIMDataType(3))), 5);
                vector.setElementAt(new CIMProperty("TimestampMonth", new CIMValue((Object)fspSharedProcPoolUtilization.getTimestampMonth(), new CIMDataType(1))), 6);
                vector.setElementAt(new CIMProperty("TimestampDay", new CIMValue((Object)fspSharedProcPoolUtilization.getTimestampDay(), new CIMDataType(1))), 7);
                vector.setElementAt(new CIMProperty("TimestampHour", new CIMValue((Object)fspSharedProcPoolUtilization.getTimestampHour(), new CIMDataType(1))), 8);
                vector.setElementAt(new CIMProperty("TimestampMinute", new CIMValue((Object)fspSharedProcPoolUtilization.getTimestampMinute(), new CIMDataType(1))), 9);
                vector.setElementAt(new CIMProperty("TimestampSeconds", new CIMValue((Object)fspSharedProcPoolUtilization.getTimestampSeconds(), new CIMDataType(1))), 10);
            }
        }
        catch (PIHscCmdMgrException pIHscCmdMgrException) {
            if (!pIHscCmdMgrException.alreadyLogged()) {
                HSCLogUtils.serverLog(pIHscCmdMgrException, HSCLogUtils._CECClassLogInfo);
                pIHscCmdMgrException.setAlreadyLogged(true);
            }
            if (pIHscCmdMgrException.isExtendedError()) {
                CmdExtendedErrorList cmdExtendedErrorList = pIHscCmdMgrException.getExtendedError();
                CmdExtendedError cmdExtendedError = cmdExtendedErrorList.getErrorAt(0);
                String[] stringArray = PICodMethProcessor.getCodExtendedErrorMsg(cmdExtendedError);
                String string = stringArray[0];
                if (stringArray[1] == null) {
                    throw new PIHscServerException(string, pIHscCmdMgrException);
                }
                String[] stringArray2 = new String[]{stringArray[1]};
                throw new PIHscServerException(string, stringArray2, pIHscCmdMgrException);
            }
            if (pIHscCmdMgrException.getStatus() == 32808) {
                throw new PIHscServerException("9010", pIHscCmdMgrException);
            }
            throw new PIHscServerException("9001", pIHscCmdMgrException);
        }
    }

    private static String[] getCodExtendedErrorMsg(CmdExtendedError cmdExtendedError) {
        String[] stringArray = null;
        int n = 0;
        byte[] byArray = new byte[4];
        byte[] byArray2 = new byte[4];
        byte[] byArray3 = new byte[2];
        String string = null;
        String string2 = null;
        long l = cmdExtendedError.extractErrorCode();
        for (int i = 0; i < Array.getLength(CodExtendedErrCodes); ++i) {
            if (l != CodExtendedErrCodes[i]) continue;
            n = i;
        }
        if (l == 1073750019L || l == 0x40002004L || l == 1073750022L || l == 1073750023L || l == 1073750024L || l == 1073750025L || l == 1073750026L || l == 1073750027L || l == 1073750028L || l == 1073750029L || l == 1073750035L || l == 1073750036L || l == 1073750040L) {
            byte[] byArray4 = cmdExtendedError.getErrorParms();
            if (byArray4.length != 0) {
                Byte by = new Byte(byArray4[10]);
                int n2 = by.intValue();
                by = new Byte(byArray4[11]);
                int n3 = by.intValue();
                by = new Byte(byArray4[12]);
                int n4 = by.intValue();
                if (n2 == 2 && n4 == 0) {
                    string2 = HSCResourceBundleUtil.encodeNLSMsg("CoDMsgBundle", ONOFF_CAPACITY_TERMINATION_ID);
                    string = setKeyErrCodeToOnoffProcMsgId[n];
                } else {
                    int n5;
                    for (n5 = 0; n5 < 4; ++n5) {
                        byArray[n5] = byArray4[0 + n5];
                        byArray2[n5] = byArray4[4 + n5];
                    }
                    for (n5 = 0; n5 < 2; ++n5) {
                        byArray3[n5] = byArray4[8 + n5];
                    }
                    if (n2 == 1 && n3 == 1) {
                        UnsignedInt32 unsignedInt32 = new UnsignedInt32((long)(ByteUtilities.byteArrayToInt(byArray) / 100));
                        String[] stringArray2 = new String[]{unsignedInt32.toString()};
                        string2 = HSCResourceBundleUtil.encodeNLSMsg("CoDMsgBundle", PERM_PROC_ACTIVATION_ID, null, stringArray2);
                        string = setKeyErrCodeToPermProcMsgId[n];
                    } else if (n2 == 1 && n3 == 2) {
                        UnsignedInt32 unsignedInt32 = new UnsignedInt32((long)(ByteUtilities.byteArrayToInt(byArray2) / 1024));
                        String[] stringArray3 = new String[]{unsignedInt32.toString()};
                        string2 = HSCResourceBundleUtil.encodeNLSMsg("CoDMsgBundle", PERM_MEM_ACTIVATION_ID, null, stringArray3);
                        string = setKeyErrCodeToPermMemMsgId[n];
                    } else if (n2 == 2) {
                        UnsignedInt16 unsignedInt16 = new UnsignedInt16((int)ByteUtilities.byteArrayToShort(byArray3));
                        String[] stringArray4 = new String[]{unsignedInt16.toString()};
                        if (n3 == 1) {
                            string2 = HSCResourceBundleUtil.encodeNLSMsg("CoDMsgBundle", ONOFF_PROC_ENABLEMENT_ID, null, stringArray4);
                            string = setKeyErrCodeToOnoffProcMsgId[n];
                        } else {
                            string2 = HSCResourceBundleUtil.encodeNLSMsg("CoDMsgBundle", ONOFF_MEM_ENABLEMENT_ID, null, stringArray4);
                            string = setKeyErrCodeToPermMemMsgId[n];
                        }
                    } else if (n2 == 3) {
                        UnsignedInt16 unsignedInt16 = new UnsignedInt16((int)ByteUtilities.byteArrayToShort(byArray3));
                        String[] stringArray5 = new String[]{unsignedInt16.toString()};
                        string2 = HSCResourceBundleUtil.encodeNLSMsg("CoDMsgBundle", METERED_PROC_ENABLEMENT_ID, null, stringArray5);
                        string = setKeyErrCodeToMeteredProcMsgId[n];
                    } else if ((n2 == 4 || n2 == 5) && n3 == 1) {
                        UnsignedInt32 unsignedInt32 = new UnsignedInt32((long)(ByteUtilities.byteArrayToInt(byArray) / 100));
                        UnsignedInt16 unsignedInt16 = new UnsignedInt16((int)ByteUtilities.byteArrayToShort(byArray3));
                        String[] stringArray6 = new String[]{unsignedInt32.toString(), unsignedInt16.toString()};
                        string2 = HSCResourceBundleUtil.encodeNLSMsg("CoDMsgBundle", TRIAL_PROC_ACTIVATION_ID, null, stringArray6);
                        string = setKeyErrCodeToTrialProcMsgId[n];
                    } else if ((n2 == 4 || n2 == 5) && n3 == 2) {
                        UnsignedInt32 unsignedInt32 = new UnsignedInt32((long)(ByteUtilities.byteArrayToInt(byArray2) / 1024));
                        UnsignedInt16 unsignedInt16 = new UnsignedInt16((int)ByteUtilities.byteArrayToShort(byArray3));
                        String[] stringArray7 = new String[]{unsignedInt32.toString(), unsignedInt16.toString()};
                        string2 = HSCResourceBundleUtil.encodeNLSMsg("CoDMsgBundle", TRIAL_MEM_ACTIVATION_ID, null, stringArray7);
                        string = setKeyErrCodeToTrialMemMsgId[n];
                    }
                }
            }
        } else {
            string = l == 0x40001001L ? "9015" : (l == 1073750037L || l == 1073750021L ? "9016" : (l == 1073750041L ? "904A" : (l == 1073754117L ? "9010" : "9001")));
        }
        if (string == null) {
            string = "9001";
        }
        stringArray = new String[]{string, string2};
        return stringArray;
    }
}

